<?php
if (!defined('ABSPATH')) exit;

class WPB_Dashboard {

    public function __construct(){
        add_action('admin_menu',[$this,'menu']);
        add_action('admin_enqueue_scripts',[$this,'assets']);
    }

    public function menu(){
        add_menu_page(
            'Woo Profit Brain',
            'Woo Profit Brain',
            'manage_woocommerce',
            'woo-profit-brain',
            [$this,'page'],
            'dashicons-chart-area',
            56
        );
    }

    public function assets($hook){
        if($hook!=='toplevel_page_woo-profit-brain') return;

        wp_enqueue_style('wpb-style',WPB_URL.'assets/css/style.css');
        wp_enqueue_script('chartjs','https://cdn.jsdelivr.net/npm/chart.js',[],null,true);
        wp_enqueue_script('wpb-script',WPB_URL.'assets/js/script.js',['jquery'],time(),true);

        wp_localize_script('wpb-script','wpb_ajax',[
            'ajax_url'=>admin_url('admin-ajax.php'),
            'nonce'=>wp_create_nonce('wpb_nonce')
        ]);
    }

    public function page(){
        include WPB_PATH.'admin/dashboard-ui.php';
    }
}
