<?php
if (!defined('ABSPATH')) exit;

class WPB_Calculations {

    /**
     * Main calculation function
     * @param string $start (Y-m-d)
     * @param string $end   (Y-m-d)
     */
    public static function get_data($start, $end) {

        // Order fetch (Processing + Completed + Refunded included for accuracy)
        $orders = wc_get_orders([
            'status' => ['wc-processing','wc-completed','wc-refunded'],
            'limit'  => -1,
            'return' => 'objects',
            'date_query' => [
                [
                    'after'     => $start . ' 00:00:00',
                    'before'    => $end . ' 23:59:59',
                    'inclusive' => true,
                ]
            ]
        ]);

        $sales   = 0;
        $shipping= 0;
        $tax     = 0;
        $cost    = 0;
        $orders_count = 0;

        foreach ($orders as $order) {

            $orders_count++;

            // -------------------------
            // SALES (Shipping excluded)
            // -------------------------
            $order_total   = (float) $order->get_total();
            $shipping_cost = (float) $order->get_shipping_total();

            $sales += ($order_total - $shipping_cost);

            // -------------------------
            // SHIPPING + TAX
            // -------------------------
            $shipping += $shipping_cost;
            $tax      += (float) $order->get_total_tax();

            // -------------------------
            // BUYING COST CALCULATION
            // (Refund aware)
            // -------------------------
            foreach ($order->get_items() as $item_id => $item) {

                $product = $item->get_product();
                if (!$product) continue;

                $qty = (float) $item->get_quantity();

                // refunded quantity
                $refunded_qty = abs(
                    (float) $order->get_qty_refunded_for_item($item_id)
                );

                // net sold quantity
                $net_qty = $qty - $refunded_qty;
                if ($net_qty <= 0) continue;

                // buying cost meta
                $buy_price = (float) get_post_meta(
                    $product->get_id(),
                    '_wpb_buying_cost',
                    true
                );

                $cost += ($buy_price * $net_qty);
            }
        }

        // -------------------------
        // PROFIT FORMULA
        // -------------------------
        $profit = $sales - ($cost + $tax);

        // Safety rounding
        $sales   = round($sales, 2);
        $shipping= round($shipping, 2);
        $tax     = round($tax, 2);
        $cost    = round($cost, 2);
        $profit  = round($profit, 2);

        return [
            'sales'        => wc_price($sales),
            'shipping'     => wc_price($shipping),
            'tax'          => wc_price($tax),
            'cost'         => wc_price($cost),
            'orders_count' => $orders_count,
            'profit'       => wc_price($profit)
        ];
    }
}