<?php
if (!defined('ABSPATH')) exit;

class WPB_Buying_Cost {

    public function __construct(){

        add_action('woocommerce_product_options_general_product_data',[$this,'field']);
        add_action('woocommerce_admin_process_product_object',[$this,'save']);

        // Add column
        add_filter('manage_edit-product_columns',[$this,'add_column']);
        add_action('manage_product_posts_custom_column',[$this,'column_value'],10,2);

        // Quick edit single field
        add_action('quick_edit_custom_box',[$this,'quick_edit'],10,2);
        add_action('save_post_product',[$this,'quick_save']);
    }

    public function field(){
        woocommerce_wp_text_input([
            'id'=>'_wpb_buying_cost',
            'label'=>'Buying Cost (৳)',
            'type'=>'number',
            'custom_attributes'=>['step'=>'0.01','min'=>'0']
        ]);
    }

    public function save($product){
        if(isset($_POST['_wpb_buying_cost'])){
            $product->update_meta_data('_wpb_buying_cost',sanitize_text_field($_POST['_wpb_buying_cost']));
        }
    }

    public function add_column($columns){
        $columns['wpb_buying_cost']='Buying Cost';
        return $columns;
    }

    public function column_value($column,$post_id){
        if($column==='wpb_buying_cost'){
            echo esc_html(get_post_meta($post_id,'_wpb_buying_cost',true));
        }
    }

    // ONLY ONE FIELD FIX
    public function quick_edit($column,$post_type){
        if($post_type!=='product' || $column!=='wpb_buying_cost') return;
        ?>
        <fieldset class="inline-edit-col-right">
            <div class="inline-edit-col">
                <label>
                    <span class="title">Buying Cost</span>
                    <span class="input-text-wrap">
                        <input type="number" step="0.01" name="_wpb_buying_cost_quick" />
                    </span>
                </label>
            </div>
        </fieldset>
        <?php
    }

    public function quick_save($post_id){
        if(isset($_POST['_wpb_buying_cost_quick'])){
            update_post_meta($post_id,'_wpb_buying_cost',sanitize_text_field($_POST['_wpb_buying_cost_quick']));
        }
    }
}
