<?php
if (!defined('ABSPATH')) exit;

class WPB_Ajax {

    public function __construct(){
        add_action('wp_ajax_wpb_get_report',[$this,'report']);
    }

    private function range_to_dates($range,$start=null,$end=null){

        switch($range){
            case 'today':
                return [date('Y-m-d'),date('Y-m-d')];
            case 'yesterday':
                return [date('Y-m-d',strtotime('-1 day')),date('Y-m-d',strtotime('-1 day'))];
            case 'week':
                return [date('Y-m-d',strtotime('monday this week')),date('Y-m-d')];
            case 'month':
                return [date('Y-m-01'),date('Y-m-d')];
            case 'year':
                return [date('Y-01-01'),date('Y-m-d')];
            default:
                return [$start,$end];
        }
    }

    public function report(){

        check_ajax_referer('wpb_nonce','nonce');

        $range=$_POST['range'];
        $start=$_POST['start'] ?? null;
        $end=$_POST['end'] ?? null;

        list($s,$e)=$this->range_to_dates($range,$start,$end);

        $data=WPB_Calculations::get_data($s,$e);

        wp_send_json($data);
    }
}
