jQuery(function($){
    let countdownInterval;

    function load_report(range, start, end) {
        let count = 3;
        
        // সব কার্ডে লোডিং স্টেট দেখানো
        $('.wpb-card strong').text('...');
        $('#profit').html('Loading (<span id="wpb-timer">3</span>s)');

        clearInterval(countdownInterval);
        
        countdownInterval = setInterval(function() {
            count--;
            if (count > 0) {
                $('#wpb-timer').text(count);
            } else {
                clearInterval(countdownInterval);
                execute_ajax(range, start, end);
            }
        }, 1000);
    }

    function execute_ajax(range, start, end) {
        $.ajax({
            url: wpb_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'wpb_get_report',
                nonce: wpb_ajax.nonce,
                range: range,
                start: start,
                end: end
            },
            success: function(res) {
                if(res) {
                    // এখানে .text() এর বদলে .html() ব্যবহার করা হয়েছে
                    $('#sales').html(res.sales);
                    $('#cost').html(res.cost);
                    $('#shipping').html(res.shipping);
                    $('#tax').html(res.tax);
                    $('#orders').text(res.orders_count); // এটি শুধু সংখ্যা তাই .text() ঠিক আছে
                    $('#profit').html(res.profit);
                }
            },
            error: function() {
                $('#profit').text('Error!');
            }
        });
    }

    // পেজ লোড হলে অটোমেটিক আজকের ডাটা দেখাবে
    load_report('today');

    // ড্রপডাউন চেঞ্জ করলে অটোমেটিক লোড হবে
    $('#wpb-range').on('change', function() {
        const range = $(this).val();
        if (range !== 'custom') {
            $('#wpb-start, #wpb-end').hide();
            load_report(range);
        } else {
            $('#wpb-start, #wpb-end').show();
        }
    });

    // কাস্টম তারিখের জন্য ফিল্টার বাটন
    $('#wpb-load').on('click', function() {
        load_report($('#wpb-range').val(), $('#wpb-start').val(), $('#wpb-end').val());
    });
});